function [ReceiveData,ActualClock]=udpspisetup(skt,ClockRate,WordBits)
%function [buff,SampleRate]=udpadc(skt,adcpins,SampleRate,SamplesToGet)
% WordBits 
% Currently ok for 
%dspic33ep256gp502
%dspic33fj128gp502
%dspic33fj128gp802
%pic24hj128gp502
% uses 
% SPI2
% DMA0 - send 
% DMA1 - receive
% RP2 - CLK
% RP3 - SO
% RP4 - SI
% RB5 - CS
%


if (nargin==1)
  ClockRate=1e6;
  WordBits=16;
end  

% Setup Pins
udpset(skt,'RPINR22',4); % RP4 as SI
udputbit(skt,'TRISB',4,1); % RB4 as input 
udpset(skt,'RPOR1',(256*10)+11); % RP3 as SO   RP2 as CLK
udputbit(skt,'TRISB',5,0);; % RB5 as CS 
%Set CS high
udputbit(skt,'LATB',5,1);


if (WordBits==16)
  M16='1';
else
  M16='0'; % 8 bits
end  

SPISTAT = 0; 
udpset(skt,'SPI2STAT',SPISTAT);

%find clocke selection lower or equal to request
CPU_Speed=udpget(skt,'CPU_SPEED');
DivR=zeros(32,1);
for x=0:31
  pp=[8 7 6 5 4 3 2 1](1+floor(x/4));
  sp=[64 16 4 1](bitand(x,3)+1);
  DivR(x+1)=pp*sp;
end  
ClockRates=CPU_Speed./DivR;
ind1=find(ClockRate>=ClockRates);
clk1=ClockRates(ind1);
[clk2,ind2]=max(clk1);
ind=ind1(ind2);
SPRE_PPRE=dec2bin(ind-1,5);
ActualClock=ClockRates(ind);

SPICON1 = bin2dec(['0000 0' M16 ' 01 001' SPRE_PPRE]);
dec2hex(SPICON1,4);
SPICON2 = 0;

udpset(skt,'SPI2CON1',SPICON1);
udpset(skt,'SPI2CON2',SPICON2);
udputbit(skt,'SPI2STAT',15,1); % Start SPI 2

%DMA_base_addr=udpget(skt,'DMA_BASE');

%[d,DMABUF_ADDR_B]=udpget(skt,'DMABufferB');
%[d,DMABUF_ADDR_C]=udpget(skt,'DMABufferC');
%[spival,SPI_ADDR]=udpget(skt,'SPI2BUF');



%DMABufferSize=max(size(d)); % in words not bytes as type is uint16
%DMABufferSize=NumChan*floor(DMABufferSize/NumChan); % whole number of sample frames in a buffer


%SingleShot = ((SamplesToGet*NumChan)<=DMABufferSize);
%if (SamplesToGet==0) 
%  SingleShot=0;
%end
% DMA channels 0-5 are unused - we will use 0
%if (SingleShot==0)
% udpset(skt,'DMA0CON',bin2dec('0000 0000 0000 0000')); % see DMAxCON in data sheet
%else
% udpset(skt,'DMA0CON',bin2dec('0000 0000 0000 0001')); % see DMAxCON in data sheet
%end
%udpset(skt,'DMA0REQ',bin2dec('0000 0000 0000 1101')); % atach to ADC eocsee DMAxREQ in data sheet
%udpset(skt,DMA,DMABUF_ADDR); %Set dma start Address in DMA0STA in data sheet
%udpset(skt,'DMA0PAD',ADC_ADDR); %Set ADC adress for dma to read
%udpset(skt,'DMA0CNT',DMABufferSize-1); %Number of values to move -1


% Set all going
%udpset(skt,'DMA0CON',bitor(bin2dec('1 0 0 0  0 0 0 0  0 0 0 0  0 0 0 0'),udpget(skt,'DMA0CON'))); % Set DMA going
%udpset(skt,'AD1CON1',bin2dec('1 0 0 1  0 1 0 0  1 0 0 0  0 1 1 1')); % Config for adc using timer 5 - see datasheet
%udpset(skt,'T5CON',bin2dec('1 0 0 0  0 0 0 0  0 0 0 0  0 0 0 0')); %Config for T5 - see datasheet


%if (SamplesToGet>0)
% if (SingleShot==0)
%  %treat DMA as fifo and chase the head
%  tail=1;
%  buf=[];
%  cnt=0;
%  while(cnt<(SamplesToGet*NumChan))
%   ptr=(udpget(skt,DMA)+DMA_base_addr-DMABUF_ADDR)/2+1;
%   if (tail>ptr)
%    data=udppeek(skt,DMABUF_ADDR+((tail-1)*2),(DMABufferSize-tail+1)*2);
%    buf=[buf data];
%    cnt=cnt+DMABufferSize-tail+1;
%    tail=1; 
%   end 
%   if (ptr>tail) 
%    data=udppeek(skt,DMABUF_ADDR+((tail-1)*2),(ptr-tail)*2);
%    buf=[buf data];
%    cnt=cnt+ptr-tail;
%    tail=ptr;
%   end
%  end
%  buf=udpgettconv(buf,2,1);
%  else
%  ptr=0;
%  pause(1/SampleRate); %wait at least 1 sample
%  while(((udpget(skt,DMA)+DMA_base_addr-DMABUF_ADDR)/2+1)>1)
%  end;
%  buf=udpget(skt,'DMABufferA'); 
% end 



 %Stop All
% udpset(skt,'T5CON',0);   % Stop T5 
% udpset(skt,'AD1CON1',0); % Stop Adc
% udpset(skt,'DMA0CON',0); % Stop DMA  

 % Top and tail the buffers
% buf=buf(1:(SamplesToGet*NumChan));
% buf=reshape(buf,NumChan,SamplesToGet)';
%else
% buf=[];
%end